/**
* \file: HIDDigitizer.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Digital iPod Out - Wayland Adapter
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_HIDDIGITIZER_H
#define CARPLAY_HIDDIGITIZER_H

#include <stdlib.h>
#include <stdint.h>
#include <dipo_plugin.h>

namespace adit { namespace carplay
{

struct HIDInputReportWithData
{
    HIDInputReport report;
    uint8_t data[12];
};

class HIDDigitizer
{
public:
    HIDDigitizer(const std::string& inUUID, const std::string& inDisplayUUID,
            const std::string& inName, bool inMultiTouch, int inVendorId, int inProductId,
            int inCountryCode);

    const HIDDevice& AsHIDDevice() const { return device; }
    const std::string& AsUUID() const { return uuid; }

    bool Down(float inX, float inY, uint32_t inID, HIDInputReportWithData& outReport);
    bool Up(uint32_t inID, HIDInputReportWithData& outReport);

    static const int TouchUp = 0;
    static const int TouchDown = 1;

private:
    std::string uuid;
    std::string displayUUID;
    std::string name;
    HIDDevice device;
    HIDInputReport report;
    uint8_t data[12];
    bool multiTouch;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_HIDDIGITIZER_H */
